/*
 * Decompiled with CFR 0.152.
 */
package org.squiddev.cobalt;

import java.util.Objects;
import java.util.function.Supplier;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.squiddev.cobalt.GlobalRegistry;
import org.squiddev.cobalt.LuaError;
import org.squiddev.cobalt.LuaTable;
import org.squiddev.cobalt.LuaThread;
import org.squiddev.cobalt.UnwindThrowable;
import org.squiddev.cobalt.compiler.BytecodeFormat;
import org.squiddev.cobalt.compiler.LoadState;
import org.squiddev.cobalt.debug.DebugFrame;
import org.squiddev.cobalt.interrupt.InterruptHandler;

public final class LuaState {
    public LuaTable stringMetatable;
    public LuaTable booleanMetatable;
    public LuaTable numberMetatable;
    public LuaTable nilMetatable;
    public LuaTable functionMetatable;
    public LuaTable threadMetatable;
    public final LoadState.FunctionFactory compiler;
    private final @Nullable BytecodeFormat bytecodeFormat;
    private volatile boolean interrupted;
    private final InterruptHandler interruptHandler;
    LuaThread currentThread;
    private final LuaThread mainThread;
    private final LuaTable globals = new LuaTable();
    private final ErrorReporter reportError;
    private final GlobalRegistry registry = new GlobalRegistry();

    public LuaState() {
        this(new Builder());
    }

    private LuaState(Builder builder) {
        this.compiler = builder.compiler;
        this.interruptHandler = builder.interruptHandler;
        this.reportError = builder.reportError;
        this.bytecodeFormat = builder.bytecodeFormat;
        this.mainThread = this.currentThread = new LuaThread(this);
    }

    public LuaTable globals() {
        return this.globals;
    }

    public GlobalRegistry registry() {
        return this.registry;
    }

    public LuaThread getMainThread() {
        return this.mainThread;
    }

    public LuaThread getCurrentThread() {
        return this.currentThread;
    }

    public @Nullable BytecodeFormat getBytecodeFormat() {
        return this.bytecodeFormat;
    }

    public void interrupt() {
        if (this.interruptHandler == null) {
            throw new IllegalStateException("LuaState has no interrupt handler");
        }
        this.interrupted = true;
    }

    public boolean isInterrupted() {
        return this.interrupted;
    }

    public void handleInterrupt() throws UnwindThrowable, LuaError {
        this.interrupted = false;
        switch (this.interruptHandler.interrupted()) {
            case CONTINUE: {
                break;
            }
            case SUSPEND: {
                if (this.currentThread.getStatus() != LuaThread.Status.RUNNING) {
                    throw new IllegalStateException("Called checkInterrupt from a " + this.currentThread.getStatus().getDisplayName() + " thread");
                }
                DebugFrame top = this.currentThread.getDebugState().getStackUnsafe();
                top.flags |= 0x40;
                throw UnwindThrowable.suspend();
            }
        }
    }

    public void handleInterruptWithoutYield() throws LuaError {
        this.interrupted = false;
        switch (this.interruptHandler.interrupted()) {
            case CONTINUE: {
                break;
            }
            case SUSPEND: {
                this.interrupted = true;
            }
        }
    }

    @Deprecated
    public void reportInternalError(Throwable error) {
        if (this.reportError != null) {
            this.reportError.report(error, () -> "Uncaught Java exception");
        }
    }

    public void reportInternalError(Throwable error, Supplier<String> message) {
        if (this.reportError != null) {
            this.reportError.report(error, message);
        }
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private LoadState.FunctionFactory compiler = LoadState::interpretedFunction;
        private @Nullable InterruptHandler interruptHandler;
        private @Nullable ErrorReporter reportError;
        private @Nullable BytecodeFormat bytecodeFormat;

        public LuaState build() {
            return new LuaState(this);
        }

        public Builder compiler(LoadState.FunctionFactory compiler) {
            Objects.requireNonNull(compiler, "compiler cannot be null");
            this.compiler = compiler;
            return this;
        }

        public Builder interruptHandler(InterruptHandler handler) {
            Objects.requireNonNull(handler, "handler cannot be null");
            this.interruptHandler = handler;
            return this;
        }

        public Builder errorReporter(ErrorReporter reporter) {
            Objects.requireNonNull(reporter, "reporter cannot be null");
            this.reportError = reporter;
            return this;
        }

        public Builder bytecodeFormat(BytecodeFormat bytecodeFormat) {
            Objects.requireNonNull(bytecodeFormat, "bytecodeFormat cannot be null");
            this.bytecodeFormat = bytecodeFormat;
            return this;
        }
    }

    public static interface ErrorReporter {
        public void report(Throwable var1, Supplier<String> var2);
    }
}

